﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetAssignedCourseSessionByCourseIdCommandHandler(
    UserInfoToken userInfoToken,
    IEmployeeCourseSessionRepository employeeCourseSessionRepository,
    IUserRepository userRepository,
    ILogger<List<GetEmployeeCourseSessionByIdCommandHandler>> logger
    ) : IRequestHandler<GetAssignedCourseSessionByCourseIdCommand, ServiceResponse<List<EmployeeAssignedCourseSessionDto>>>
{
    public async Task<ServiceResponse<List<EmployeeAssignedCourseSessionDto>>> Handle(GetAssignedCourseSessionByCourseIdCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var employee = await userRepository.All.Where(d => d.Email == userInfoToken.Email).FirstOrDefaultAsync();
            if (employee == null)
            {
                return ServiceResponse<List<EmployeeAssignedCourseSessionDto>>.Return404("Employee Not Found");
            }

            var employeeCourseSession = await employeeCourseSessionRepository
                                        .All
                                        .Include(d => d.CourseSession)
                                        .Where(d => d.CourseSession.CourseId == request.CourseId && d.EmployeeId == employee.Id)
                                        .Select(employeeCourseSession => new EmployeeAssignedCourseSessionDto
                                        {
                                            Id = employeeCourseSession.Id,
                                            SessionName = employeeCourseSession.CourseSession.Title,
                                            CompletedDate = employeeCourseSession.CompletedDate,
                                            Result = employeeCourseSession.IsPassed,
                                        }).ToListAsync();

            return ServiceResponse<List<EmployeeAssignedCourseSessionDto>>.ReturnResultWith200(employeeCourseSession);
        }
        catch (Exception ex)
        {
            logger.LogError(ex, "Error occurred while getting employee course session.");
            return ServiceResponse<List<EmployeeAssignedCourseSessionDto>>.Return500("An error occurred while getting employee course session.");
        }
    }
}
