﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Entities;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAssignedEmployeeCoursesStatusCountCommandHandler(
        IEmployeeCourseRepository _employeeCourseRepository,
        ILogger<GetAssignedEmployeeCoursesStatusCountCommandHandler> _logger) : IRequestHandler<GetAssignedEmployeeCoursesStatusCountCommand, ServiceResponse<CoursesStatusCountDto>>
    {
        public async Task<ServiceResponse<CoursesStatusCountDto>> Handle(GetAssignedEmployeeCoursesStatusCountCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var courses = await _employeeCourseRepository.All.Where(c=>c.CourseId==request.CourseId).ToListAsync();
                var count = new CoursesStatusCountDto
                {
                    CoursesCompleteCount = courses.Count(c => c.Status == EmployeeCourseStatus.Completed),
                    CoursesInProgressCount = courses.Count(c => c.Status == EmployeeCourseStatus.InProgress),
                    CoursesPendingCount = courses.Count(c => c.Status == EmployeeCourseStatus.Pending)

                };
                return ServiceResponse<CoursesStatusCountDto>.ReturnResultWith200(count);
            }
            catch(System.Exception ex)
            {
                _logger.LogError(ex, "error while gettimh course Status count");
                return ServiceResponse<CoursesStatusCountDto>.Return500("error while gettimh course Status count");
            }
         
        }
    }
}
