﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetEmployeeAsignAllInProgressCoursesCommandHandler(
        IEmployeeCourseRepository _employeeCourseRepository,
        UserInfoToken _userInfoToken,
        IMapper _mapper,
        ILogger<GetEmployeeAsignAllInProgressCoursesCommandHandler> _logger) : IRequestHandler<GetEmployeeAsignAllInProgressCoursesCommand, ServiceResponse<List<EmployeeCourseDto>>>
    {
        public async Task<ServiceResponse<List<EmployeeCourseDto>>> Handle(GetEmployeeAsignAllInProgressCoursesCommand request, CancellationToken cancellationToken)
        {
            try
            {
                Guid userId = _userInfoToken.Id;
                var employeeCourses = await _employeeCourseRepository.All.Where(c => c.Status == EmployeeCourseStatus.InProgress)
                    .Include(c => c.Course).ThenInclude(c => c.CourseSessions)
                    .Include(c => c.EmployeeCourseSessions)
                    .Where(c => c.EmployeeId == userId).ToListAsync();
                var empCoursesDto = _mapper.Map<List<EmployeeCourseDto>>(employeeCourses);
                foreach (var dto in empCoursesDto)
                {
                    dto.TotalSessionCount = dto.Course?.CourseSessions?.Count ?? 0;
                    dto.TotalCompletedSessionCount = dto.EmployeeCourseSessions?.Count(s => s.IsPassed) ?? 0;
                }

                return ServiceResponse<List<EmployeeCourseDto>>.ReturnResultWith200(empCoursesDto);
            }
            catch (Exception ex)
            {
                _logger.LogError(ex, "error while getting employee cources");
                return ServiceResponse<List<EmployeeCourseDto>>.Return500("error while getting employee cources");
            }
        }
    }
}
