﻿using MediatR;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR.EmployeeCourses;
public class SearchEmployeeListCommandHandler(
    IUserRepository userRepository)
    : IRequestHandler<SearchEmployeeListCommand, EmployeeCourseList>
{
    public async Task<EmployeeCourseList> Handle(SearchEmployeeListCommand request, CancellationToken cancellationToken)
    {
        return await userRepository.GetCourseEmployees(request.EmployeeResource);
    }
}
