﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetFileRequestDocumentQueryHandler(IFileRequestDocumentRepository _fileRequestDocumentRepository, IMapper _mapper) : IRequestHandler<GetFileRequestDocumentQuery, ServiceResponse<FileRequestDocumentDto>>
    {
        public async Task<ServiceResponse<FileRequestDocumentDto>> Handle(GetFileRequestDocumentQuery request, CancellationToken cancellationToken)
        {
            var entity = await _fileRequestDocumentRepository.All
                .FirstOrDefaultAsync(c => c.Id == request.Id);
            if (entity == null)
            {
                return ServiceResponse<FileRequestDocumentDto>.Return404();
            }

            var entityDto = _mapper.Map<FileRequestDocumentDto>(entity);
            return ServiceResponse<FileRequestDocumentDto>.ReturnResultWith200(entityDto);
        }
    }
}
