﻿using AutoMapper;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class UpdateFileRequestDocumentCommandHandler(IFileRequestDocumentRepository _fileRequestDocumentRepository, UserInfoToken _userInfoToken, IUnitOfWork<QMSDbContext> _uow, IMapper _mapper) : IRequestHandler<UpdateFileRequestDocumentCommand, ServiceResponse<FileRequestDocumentDto>>
    {
        public async Task<ServiceResponse<FileRequestDocumentDto>> Handle(UpdateFileRequestDocumentCommand request, CancellationToken cancellationToken)
        {
            var entityExist = await _fileRequestDocumentRepository.All
                .FirstOrDefaultAsync(c => c.Id == request.Id);
            if (entityExist == null)
            {
                return ServiceResponse<FileRequestDocumentDto>.Return409("File request document does not exists.");
            }
            entityExist.Reason = request.Reason;
            entityExist.FileRequestDocumentStatus = FileRequestDocumentStatus.REJECTED;
            entityExist.ApprovalOrRjectedById = _userInfoToken.Id;
            entityExist.ApprovedRejectedDate = DateTime.UtcNow;
            _fileRequestDocumentRepository.Update(entityExist);
            if (await _uow.SaveAsync() <= 0)
            {
                return ServiceResponse<FileRequestDocumentDto>.Return500();
            }
            var entityDto = _mapper.Map<FileRequestDocumentDto>(entityExist);

            return ServiceResponse<FileRequestDocumentDto>.ReturnResultWith200(entityDto);
        }
    }
}
