﻿using System;
using MediatR;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Helper;

namespace QualityManagement.MediatR;

public class AddNonConformanceCommand : IRequest<ServiceResponse<NonConformanceDto>>
{
    public string Title { get; set; }
    public Guid ReportedById { get; set; }
    public Guid? DepartmentId { get; set; }
    public string Description { get; set; }
    public string NcNumber { get; set; }
    public NonConformanceSeverity Severity { get; set; }
    public NonConformanceStatus Status { get; set; }
    public DateTime? ClosedDate { get; set; }
    public Guid? AuditId { get; set; }
    public Guid? AuditResponseId { get; set; }

}
