﻿using System;
using FluentValidation;

namespace QualityManagement.MediatR;

public class AddNonConformanceCommandValidator : AbstractValidator<AddNonConformanceCommand>
{
    public AddNonConformanceCommandValidator()
    {
        RuleFor(c => c.ReportedById).Must(NotEmptyGuid).WithMessage("ReportedBy Id is required");
    }
    private bool NotEmptyGuid(Guid p)
    {
        return p != Guid.Empty;
    }
}
