﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetNonConformanceOverviewCommandHandler(
   INonConformanceRepository nonConformanceRepository,
   ILogger<GetNonConformanceOverviewCommandHandler> logger) : IRequestHandler<GetNonConformanceOverviewCommand, List<NameCountDto>>
{
    public async Task<List<NameCountDto>> Handle(GetNonConformanceOverviewCommand request, CancellationToken cancellationToken)
    {
        try
        {
            IQueryable<NonConformance> nonConformances;

            if (request.FromDate.HasValue && request.ToDate.HasValue)
            {
                var startDate = request.FromDate.Value;
                var endDate = request.ToDate.Value;

                DateTime minDate = new DateTime(startDate.Year, startDate.Month, startDate.Day, 0, 0, 0);
                DateTime maxDate = new DateTime(endDate.Year, endDate.Month, endDate.Day, 23, 59, 59);

                nonConformances = nonConformanceRepository.All
                    .Where(c => c.CreatedDate >= minDate && c.CreatedDate <= maxDate);
            }
            else
            {
                nonConformances = nonConformanceRepository.All;
            }

            var nonConformanceOverview = await nonConformances
               .GroupBy(a => a.Status)
               .Select(g => new NameCountDto
               {
                   Name = g.Key.ToString(),
                   Count = g.Count()
               })
               .ToListAsync(cancellationToken);

            return nonConformanceOverview;
        }
        catch (Exception ex)
        {
            logger.LogError(ex, "Error occurred while handling GetNonConformanceOverviewCommand");
            return new List<NameCountDto>();
        }
    }
}
