﻿using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteNonConformanceCommandHandler(INonConformanceRepository _nonConformanceRepository,
        ILogger<DeleteNonConformanceCommandHandler> _logger,
        IUnitOfWork<QMSDbContext> _uow) : IRequestHandler<DeleteNonConformanceCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteNonConformanceCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var existEntity = await _nonConformanceRepository.FindAsync(request.Id);
                if (existEntity == null)
                {
                    return ServiceResponse<bool>.Return404("NonConformance not found");
                }
                existEntity.IsDeleted = true;
                _nonConformanceRepository.Update(existEntity);
                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<bool>.Return500();
                }
                return ServiceResponse<bool>.ReturnResultWith200(true);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while deleting NonConformance");
                return ServiceResponse<bool>.Return500("Error while deleting NonConformance");
            }
        }
    }
}
