﻿using MediatR;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetNonConformanceListCommandHandler(INonConformanceRepository nonConformanceRepository) : IRequestHandler<GetNonConformanceListCommand, NonConformanceList>
    {
        public async Task<NonConformanceList> Handle(GetNonConformanceListCommand request, CancellationToken cancellationToken)
        {
            return await nonConformanceRepository.GetNonConformances(request.NonConformanceResource);
        }
    }
}
