﻿using MediatR;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetNonConformanceLogListCommandHandler(
        INonConformanceLogRepository _nonConformanceLogRepository) : IRequestHandler<GetNonConformanceLogListCommand, NonConformanceLogList>
    {
        public async Task<NonConformanceLogList> Handle(GetNonConformanceLogListCommand request, CancellationToken cancellationToken)
        {
            return await _nonConformanceLogRepository.GetNonConformanceLogs(request.NonConformanceLogResource);
        }
    }
}
