﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class GetNonConformanceResponseCommandHandler(
     INonConformanceResponseRepository _nonConformanceResponseRepository,
        IMapper _mapper,
        ILogger<GetNonConformanceResponseCommandHandler> _logger
    ) : IRequestHandler<GetNonConformanceResponseCommand, ServiceResponse<NonConformanceResponseDto>>
{
    public async Task<ServiceResponse<NonConformanceResponseDto>> Handle(GetNonConformanceResponseCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var entity = await _nonConformanceResponseRepository.AllIncluding(c => c.NonConformanceRespAttachments)
                .Where(c => c.Id == request.Id)
                .FirstOrDefaultAsync();
            if (entity == null)
            {
                return ServiceResponse<NonConformanceResponseDto>.Return404();
            }
            var entityDto = _mapper.Map<NonConformanceResponseDto>(entity);
            return ServiceResponse<NonConformanceResponseDto>.ReturnResultWith200(entityDto);
        }
        catch (System.Exception ex)
        {
            _logger.LogError(ex, "Error while Get NonConformanceResponse");
            return ServiceResponse<NonConformanceResponseDto>.Return500();
        }
    }
}
