﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Linq;
using System.Linq.Dynamic.Core;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddNonConformanceResponseTypeCommandHandler(
        INonConformanceResponseTypeRepository _nonConformanceResponseTypeRepository,
        IMapper _mapper,
        ILogger<AddNonConformanceResponseTypeCommandHandler> _logger,
        IUnitOfWork<QMSDbContext> _uow)
        : IRequestHandler<AddNonConformanceResponseTypeCommand, ServiceResponse<NonConformanceResponseTypeDto>>
    {
        public async Task<ServiceResponse<NonConformanceResponseTypeDto>> Handle(AddNonConformanceResponseTypeCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var existingEntity = await _nonConformanceResponseTypeRepository.All
                    .Where(n => n.Name.ToLower() == request.Name.ToLower())
                    .FirstOrDefaultAsync();
                if (existingEntity != null)
                {
                    return ServiceResponse<NonConformanceResponseTypeDto>.Return409("NonConformanceResponseType name already exist");
                }

                var entity = _mapper.Map<NonConformanceResponseType>(request);
                _nonConformanceResponseTypeRepository.Add(entity);

                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<NonConformanceResponseTypeDto>.Return500();
                }

                var entityDto = _mapper.Map<NonConformanceResponseTypeDto>(entity);
                return ServiceResponse<NonConformanceResponseTypeDto>.ReturnResultWith201(entityDto);

            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while saving NonConformanceResponseType ");
                return ServiceResponse<NonConformanceResponseTypeDto>.Return500("Error while saving NonConformanceResponseType");
            }
        }
    }
}
