﻿using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteNonConformanceResponseTypeCommandHandler(
        INonConformanceResponseTypeRepository _nonConformanceResponseTypeRepository,
        ILogger<DeleteNonConformanceResponseTypeCommandHandler> _Logger,
        IUnitOfWork<QMSDbContext> _uow) : IRequestHandler<DeleteNonConformanceResponseTypeCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteNonConformanceResponseTypeCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entity = await _nonConformanceResponseTypeRepository.FindAsync(request.Id);
                if (entity == null)
                {
                    return ServiceResponse<bool>.Return404();
                }
                _nonConformanceResponseTypeRepository.Remove(entity);
                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<bool>.Return500();
                }
                return ServiceResponse<bool>.ReturnResultWith200(true);
            }
            catch (System.Exception ex)
            {
                _Logger.LogError(ex, "Error while Deleting NonConformanceResponseType");
                return ServiceResponse<bool>.Return500("Error while Deleting NonConformanceResponseType");
            }

        }
    }
}
