﻿using AutoMapper;
using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetNonConformanceResponseTypeCommandHandler(
        INonConformanceResponseTypeRepository _nonConformanceResponseTypeRepository,
        IMapper _mapper,
        ILogger<GetNonConformanceResponseTypeCommandHandler> _logger
        ) : IRequestHandler<GetNonConformanceResponseTypeCommand, ServiceResponse<NonConformanceResponseTypeDto>>
    {
        public async Task<ServiceResponse<NonConformanceResponseTypeDto>> Handle(GetNonConformanceResponseTypeCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entity = await _nonConformanceResponseTypeRepository.FindAsync(request.Id);
                if (entity == null)
                {
                    return ServiceResponse<NonConformanceResponseTypeDto>.Return404();
                }
                var entityDto = _mapper.Map<NonConformanceResponseTypeDto>(entity);
                return ServiceResponse<NonConformanceResponseTypeDto>.ReturnResultWith200(entityDto);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while Get NonConformanceResponseType");
                return ServiceResponse<NonConformanceResponseTypeDto>.Return500();
            }

        }
    }
}
