﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class CreatePageHelperCommandHandler(
        IPageHelperRepository _pageHelperRepository,
        IUnitOfWork<QMSDbContext> _uow,
        IMapper _mapper) : IRequestHandler<CreatePageHelperCommand, ServiceResponse<PageHelperDto>>
    {
        public async Task<ServiceResponse<PageHelperDto>> Handle(CreatePageHelperCommand request, CancellationToken cancellationToken)
        {
            var entityExist = await _pageHelperRepository.FindBy(c => c.Name.ToUpper() == request.Name.ToUpper()).FirstOrDefaultAsync();
            if (entityExist != null)
            {
                return ServiceResponse<PageHelperDto>.Return409("Page helper with same name already exists.");
            }

            var entity = _mapper.Map<PageHelper>(request);
            entity.Code = entity.Name.ToUpper().Replace(" ", "_");
            entity.Id = Guid.NewGuid();

            _pageHelperRepository.Add(entity);
            if (await _uow.SaveAsync() <= 0)
            {
                return ServiceResponse<PageHelperDto>.Return500();
            }
            var entityDto = _mapper.Map<PageHelperDto>(entity);
            return ServiceResponse<PageHelperDto>.ReturnResultWith201(entityDto);
        }
    }
}
