﻿using MediatR;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeletePageHelperCommandHandler(
        IPageHelperRepository _pageHelperRepository,
        IUnitOfWork<QMSDbContext> _uow) : IRequestHandler<DeletePageHelperCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeletePageHelperCommand request, CancellationToken cancellationToken)
        {
            var entityExist = await _pageHelperRepository.FindAsync(request.Id);

            if (entityExist == null)
            {
                return ServiceResponse<bool>.Return404();
            }

            _pageHelperRepository.Delete(request.Id);

            if (await _uow.SaveAsync() <= 0)
            {
                return ServiceResponse<bool>.Return500();
            }
            return ServiceResponse<bool>.ReturnSuccess();
        }
    }
}
