﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllPageHelpersCommandHandler(
        IPageHelperRepository _pageHelperRepository) : IRequestHandler<GetAllPageHelpersCommand, List<PageHelperDto>>
    {
        public async Task<List<PageHelperDto>> Handle(GetAllPageHelpersCommand request, CancellationToken cancellationToken)
        {
            var entities = await _pageHelperRepository.All.Select(c => new PageHelperDto
            {
                Id = c.Id,
                Code = c.Code,
                Name = c.Name
            }).ToListAsync();

            return entities;
        }
    }
}
