﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetPageHelperByCodeCommandHandler(
        IPageHelperRepository _pageHelperRepository,
        IMapper _mapper) : IRequestHandler<GetPageHelperByCodeCommand, ServiceResponse<PageHelperDto>>
    {

        public async Task<ServiceResponse<PageHelperDto>> Handle(GetPageHelperByCodeCommand request, CancellationToken cancellationToken)
        {
            var entity = await _pageHelperRepository.All.FirstOrDefaultAsync(c => c.Code == request.Code);
            if (entity != null)
            {
                var dto = _mapper.Map<PageHelperDto>(entity);
                return ServiceResponse<PageHelperDto>.ReturnResultWith200(dto);
            }
            return ServiceResponse<PageHelperDto>.Return404("Page Helper not found");
        }
    }
}
