﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class UpdatePageHelperCommandHandler(
        IPageHelperRepository _pageHelperRepository,
        IUnitOfWork<QMSDbContext> _uow,
        IMapper _mapper) : IRequestHandler<UpdatePageHelperCommand, ServiceResponse<PageHelperDto>>
    {
        public async Task<ServiceResponse<PageHelperDto>> Handle(UpdatePageHelperCommand request, CancellationToken cancellationToken)
        {
            var entityExist = await _pageHelperRepository.All.FirstOrDefaultAsync(c => c.Name.ToUpper() == request.Name.ToUpper() && c.Id != request.Id);
            if (entityExist != null)
            {
                return ServiceResponse<PageHelperDto>.Return409("Page Helper with same name already exists.");
            }

            entityExist = await _pageHelperRepository.All.FirstOrDefaultAsync(c => c.Id == request.Id);

            if (entityExist == null)
            {
                return ServiceResponse<PageHelperDto>.Return409("Page Helper does not exists.");
            }

            entityExist.Name = request.Name;
            entityExist.Description = request.Description;
            _pageHelperRepository.Update(entityExist);

            if (await _uow.SaveAsync() <= 0)
            {
                return ServiceResponse<PageHelperDto>.Return500();
            }

            var entityDto = _mapper.Map<PageHelperDto>(entityExist);
            return ServiceResponse<PageHelperDto>.ReturnResultWith200(entityDto);
        }
    }
}
