﻿using AutoMapper;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddPageCommandHandler(
        IPageRepository pageRepository,
        IMapper mapper,
        IUnitOfWork<QMSDbContext> uow,
        ILogger<AddPageCommandHandler> logger
        ) : IRequestHandler<AddPageCommand, ServiceResponse<PageDto>>
    {
        public async Task<ServiceResponse<PageDto>> Handle(AddPageCommand request, CancellationToken cancellationToken)
        {
            var existingEntity = await pageRepository.FindBy(c => c.Name == request.Name).FirstOrDefaultAsync(cancellationToken);
            if (existingEntity != null)
            {
                logger.LogError("Page Already Exist");
                return ServiceResponse<PageDto>.Return409("Page Already Exist.");
            }
            var entity = mapper.Map<Page>(request);
            pageRepository.Add(entity);

            if (await uow.SaveAsync(cancellationToken) <= 0)
            {
                logger.LogError("Save Page have Error");
                return ServiceResponse<PageDto>.Return500();
            }
            return ServiceResponse<PageDto>.ReturnResultWith200(mapper.Map<PageDto>(entity));
        }
    }
}
