﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.Extensions.Logging;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetPageQueryHandler(
        IPageRepository pageRepository,
        IMapper mapper,
        ILogger<GetPageQueryHandler> logger) : IRequestHandler<GetPageQuery, ServiceResponse<PageDto>>
    {
        public async Task<ServiceResponse<PageDto>> Handle(GetPageQuery request, CancellationToken cancellationToken)
        {

            var entity = await pageRepository.FindAsync(request.Id);
            if (entity != null)
                return ServiceResponse<PageDto>.ReturnResultWith200(mapper.Map<PageDto>(entity));
            else
            {
                logger.LogError("Not found");
                return ServiceResponse<PageDto>.Return404();
            }
        }
    }
}
