﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;

public class UpdatePageCommandHandler(
    IPageRepository _pageRepository,
    IUnitOfWork<QMSDbContext> _uow,
    IMapper _mapper,
     ILogger<UpdatePageCommandHandler> _logger) : IRequestHandler<UpdatePageCommand, ServiceResponse<PageDto>>
{
    public async Task<ServiceResponse<PageDto>> Handle(UpdatePageCommand request, CancellationToken cancellationToken)
    {
        var entityExist = await _pageRepository.FindBy(c => c.Name == request.Name && c.Id != request.Id)
            .FirstOrDefaultAsync();
        if (entityExist != null)
        {
            _logger.LogError("Page Name Already Exist.");
            return ServiceResponse<PageDto>.Return409("Page Name Already Exist.");
        }
        entityExist = await _pageRepository.FindBy(v => v.Id == request.Id).FirstOrDefaultAsync();

        if (entityExist == null)
        {
            _logger.LogError("Page Not Found.");
            return ServiceResponse<PageDto>.Return404("Page Not Found.");
        }

        entityExist.Name = request.Name;
        entityExist.Order = request.Order;
        _pageRepository.Update(entityExist);
        if (await _uow.SaveAsync() <= 0)
        {
            return ServiceResponse<PageDto>.Return500();
        }
        return ServiceResponse<PageDto>.ReturnResultWith200(_mapper.Map<PageDto>(entityExist));
    }
}
