﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data;
using QualityManagement.Repository;
using System;
using System.Data;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class CustomDateReminderServicesQueryHandler(
         IReminderRepository _reminderRepository,
         IReminderSchedulerRepository _reminderSchedulerRepository) : IRequestHandler<CustomDateReminderServicesQuery, bool>
    {

        public async Task<bool> Handle(CustomDateReminderServicesQuery request, CancellationToken cancellationToken)
        {
            var toDate = new DateTime(DateTime.Now.Year, DateTime.Now.Month, DateTime.Now.Day, 0, 0, 0).ToUniversalTime();
            var fromDate = new DateTime(DateTime.Now.Year, DateTime.Now.Month, DateTime.Now.Day, 23, 59, 59).ToUniversalTime();

            var reminders = await _reminderRepository
                .All
                .Include(c => c.ReminderUsers)
                .Where(c => c.Frequency == Frequency.OneTime && !c.IsRepeated
                        && c.StartDate >= toDate
                        && c.StartDate <= fromDate)
                .ToListAsync();
            if (reminders.Count() > 0)
            {
                return await _reminderSchedulerRepository.AddMultiReminder(reminders);
            }
            return true;
        }
    }
}
