﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data;
using QualityManagement.Repository;
using System;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class HalfYearlyReminderServiceQueryHandler(
        IReminderRepository _reminderRepository,
        IReminderSchedulerRepository _reminderSchedulerRepository) : IRequestHandler<HalfYearlyReminderServiceQuery, bool>
    {
        public async Task<bool> Handle(HalfYearlyReminderServiceQuery request, CancellationToken cancellationToken)
        {
            var currentDate = new DateTime(DateTime.Now.Year, DateTime.Now.Month, DateTime.Now.Day, DateTime.Now.Hour, DateTime.Now.Minute, DateTime.Now.Second).ToUniversalTime();

            var reminders = await _reminderRepository.All
                   .Include(c => c.ReminderUsers)
                   .Where(c => c.Frequency == Frequency.HalfYearly
            && c.StartDate <= currentDate && (!c.EndDate.HasValue || c.EndDate >= currentDate)
            && c.HalfYearlyReminders.Any(qr => qr.Day == currentDate.Day && qr.Month == currentDate.Month)
             )
            .ToListAsync();

            if (reminders != null && reminders.Count() > 0)
            {
                return await _reminderSchedulerRepository.AddMultiReminder(reminders);
            }
            return true;


        }
    }
}
