﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data;
using QualityManagement.Repository;
using System;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class YearlyReminderServicesQueryHandler(
        IReminderRepository _reminderRepository,
        IReminderSchedulerRepository _reminderSchedulerRepository) : IRequestHandler<YearlyReminderServicesQuery, bool>
    {
        public async Task<bool> Handle(YearlyReminderServicesQuery request, CancellationToken cancellationToken)
        {
            var currentDate = new DateTime(DateTime.Now.Year, DateTime.Now.Month, DateTime.Now.Day, DateTime.Now.Hour, DateTime.Now.Minute, DateTime.Now.Second).ToUniversalTime();

            var reminders = await _reminderRepository.All
                             .Include(c => c.ReminderUsers)
                             .Where(c => c.Frequency == Frequency.Yearly
                                      && c.StartDate <= currentDate && (!c.EndDate.HasValue || c.EndDate >= currentDate)
                                      && c.StartDate.Day == currentDate.Day && c.StartDate.Month == currentDate.Month)
                                      .ToListAsync();

            if (reminders != null && reminders.Count() > 0)
            {
                return await _reminderSchedulerRepository.AddMultiReminder(reminders);
            }
            return true;
        }
    }
}
