﻿using AutoMapper;
using MediatR;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddReminderCommandHandler(
        IReminderRepository _reminderRepository,
        IMapper _mapper,
        IUnitOfWork<QMSDbContext> _uow,
        UserInfoToken _userInfoToken) : IRequestHandler<AddReminderCommand, ServiceResponse<ReminderDto>>
    {
        public async Task<ServiceResponse<ReminderDto>> Handle(AddReminderCommand request, CancellationToken cancellationToken)
        {
            if (!request.Frequency.HasValue)
            {
                request.Frequency = Frequency.OneTime;
            }
            if (!request.IsRepeated)
            {
                request.Frequency = Frequency.OneTime;
            }

            if (!request.ReminderUsers.Any(c => c.UserId == _userInfoToken.Id))
            {
                request.ReminderUsers.Add(new ReminderUserDto
                {
                    UserId = _userInfoToken.Id
                });
            }
            var reminder = _mapper.Map<Reminder>(request);
            _reminderRepository.Add(reminder);
            if (await _uow.SaveAsync() <= 0)
            {
                return ServiceResponse<ReminderDto>.Return500();
            }

            return ServiceResponse<ReminderDto>.ReturnResultWith201(_mapper.Map<ReminderDto>(reminder));
        }
    }
}
