﻿using MediatR;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteReminderCommandHandler(
        IReminderRepository _reminderRepository,
         IUnitOfWork<QMSDbContext> _uow) : IRequestHandler<DeleteReminderCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteReminderCommand request, CancellationToken cancellationToken)
        {
            var reminder = await _reminderRepository.FindAsync(request.Id);
            if (reminder == null)
            {
                return ServiceResponse<bool>.Return404();
            }

            reminder.IsDeleted = true;
            _reminderRepository.Update(reminder);
            if (await _uow.SaveAsync() <= -1)
            {
                return ServiceResponse<bool>.Return500();
            }

            return ServiceResponse<bool>.ReturnSuccess();
        }
    }
}
