﻿using MediatR;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetReminderForLoginUserCommandHandler(
        IReminderRepository _reminderRepository) : IRequestHandler<GetReminderForLoginUserCommand, ReminderList>
    {
        public async Task<ReminderList> Handle(GetReminderForLoginUserCommand request, CancellationToken cancellationToken)
        {
            return await _reminderRepository.GetRemindersForLoginUser(request.ReminderResource);
        }
    }
}
