﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetUserNotificationCountQueryHandler(
        IReminderSchedulerRepository _reminderSchedulerRepository,
        UserInfoToken _userInfoToken) : IRequestHandler<GetUserNotificationCountQuery, int>
    {
        public async Task<int> Handle(GetUserNotificationCountQuery request, CancellationToken cancellationToken)
        {
            var count = await _reminderSchedulerRepository.All.CountAsync(c => c.UserId == _userInfoToken.Id && !c.IsRead);
            return count;
        }
    }
}
