﻿using MediatR;
using QualityManagement.Data;
using QualityManagement.Data.Dto.RiskManagement;
using QualityManagement.Data.Entities;
using QualityManagement.Data.Entities.RiskManagment;
using QualityManagement.Helper;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddRiskCommand:IRequest<ServiceResponse<RiskDto>>
    {
        public string Title { get; set; }
        public string Description { get; set; }
        public Guid RiskCategoryId { get; set; }
        public int Likelihood { get; set; }
        public int Severity { get; set; } 
        public RiskStatusEnum Status { get; set; }
        public Guid AssignedToId { get; set; }
    }
}
