﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddRiskCommandValidator:AbstractValidator<AddRiskCommand>
    {
        public AddRiskCommandValidator()
        {
            RuleFor(c => c.AssignedToId).Must(GuidNotEmpty).WithMessage("assignedTo id is required");
            RuleFor(c => c.Title).NotEmpty().WithMessage("title is required");
            RuleFor(c => c.Likelihood).InclusiveBetween(1, 5).WithMessage("likelihood must be between 1 and 5");
            RuleFor(c => c.Severity).InclusiveBetween(1, 5).WithMessage("Severity must be between 1 and 5");
            RuleFor(c => c.RiskCategoryId).Must(GuidNotEmpty).WithMessage("RiskCategory id is required");
        }
        private bool GuidNotEmpty(Guid p)
        {
            return p != Guid.Empty;
        }
    }
}
