﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using NPOI.OpenXmlFormats.Wordprocessing;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository.RiskManagment;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR.RiskManagement
{
    public class DeleteRiskCommandHandler(
        IRiskRepository _riskRepository,
        IUnitOfWork<QMSDbContext> _uow,
        ILogger<DeleteRiskCommandHandler> _logger) : IRequestHandler<DeleteRiskCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteRiskCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entity = await _riskRepository.All.Where(c => c.Id == request.Id).FirstOrDefaultAsync();
                if (entity == null)
                {
                    return ServiceResponse<bool>.Return404("risk not found");
                }
                _riskRepository.Delete(entity);
                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<bool>.Return500();
                }
                return ServiceResponse<bool>.ReturnResultWith200(true);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while deleting Risk");
                return ServiceResponse<bool>.Return500("Error while deleting risk ");
            }

        }
    }
}
