﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto.RiskManagement;
using QualityManagement.Helper;
using QualityManagement.Repository.RiskManagment;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR.RiskManagement
{
    public class GetRiskCommandHandler(
        IRiskRepository _riskRepository,
        IMapper _mapper,
        ILogger<GetRiskCommandHandler> _logger) : IRequestHandler<GetRiskCommand, ServiceResponse<RiskDto>>
    {
        public async Task<ServiceResponse<RiskDto>> Handle(GetRiskCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entity = await _riskRepository
                .All
                .Where(c => c.Id == request.Id).FirstOrDefaultAsync();
                if (entity == null)
                {
                    return ServiceResponse<RiskDto>.Return404(" risk not found");
                }
                var entityDto = _mapper.Map<RiskDto>(entity);
                return ServiceResponse<RiskDto>.ReturnResultWith201(entityDto);
            }
            catch (System.Exception ex) 
            {
                _logger.LogError(ex,"Error while getting Risk");
                return ServiceResponse<RiskDto>.Return500("Error while getting Risk");
            }
            

        }
    }
}
