﻿using MediatR;
using QualityManagement.Helper;
using QualityManagement.Repository.RiskManagment;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR.RiskManagement
{
    public class GetRiskListCommandHandler(
        IRiskRepository _riskRepository) : IRequestHandler<GetRiskListCommand, RiskList>
    {
        public async Task<RiskList> Handle(GetRiskListCommand request, CancellationToken cancellationToken)
        {
            return await _riskRepository.GetRisk(request.RiskResource);
        }
    }
}
