﻿using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using QualityManagement.Repository.RiskManagment;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR.RiskManagement
{
    public class DeleteRiskAttachmentCommandHandler (
    IUnitOfWork<QMSDbContext> _uow,
    IRiskAttachmentRepository _riskAttachmentRepository,
    ILogger<DeleteRiskAttachmentCommandHandler> _logger) : IRequestHandler<DeleteRiskAttachmentCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteRiskAttachmentCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entityExist = await _riskAttachmentRepository.FindAsync(request.Id);
                if (entityExist == null)
                {
                    return ServiceResponse<bool>.ReturnFailed(404, "riskAttachment not found.");
                }

                _riskAttachmentRepository.Remove(entityExist);
                if (await _uow.SaveAsync() <= 0)
                {
                    return ServiceResponse<bool>.ReturnFailed(500, "Error while deleting risk attachment.");
                }
                return ServiceResponse<bool>.ReturnResultWith200(true);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while deleting risk attachment.");
                return ServiceResponse<bool>.ReturnFailed(500, "Error while deleting risk attachment.");
            }
        }
    }
}
