﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto.RiskManagement;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddRiskCategoryCommandHandler(
        IRiskCategoryRepository _riskCategoryRepository,
        IMapper _mapper,
        IUnitOfWork<QMSDbContext> _uow,
        ILogger<AddRiskCategoryCommandHandler> _logger) : IRequestHandler<AddRiskCategoryCommand, ServiceResponse<RiskCategoryDto>>
    {
        public async Task<ServiceResponse<RiskCategoryDto>> Handle(AddRiskCategoryCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var existingEntity = await _riskCategoryRepository.All
                   .Where(s => s.Name.ToLower() == request.Name.ToLower()).FirstOrDefaultAsync();
                if (existingEntity != null)
                {
                    return ServiceResponse<RiskCategoryDto>.Return409("RiskCategory name is already exist");
                }

                var entity = _mapper.Map<RiskCategory>(request);

                _riskCategoryRepository.Add(entity);
                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<RiskCategoryDto>.Return500();
                }
                var entityDto = _mapper.Map<RiskCategoryDto>(entity);
                return ServiceResponse<RiskCategoryDto>.ReturnResultWith201(entityDto);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while saving RiskCategory");
                return ServiceResponse<RiskCategoryDto>.Return500("Error while saving RiskCategory");
            }
        }
    }
}
