﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteRiskCategoryCommandHandler(
        IRiskCategoryRepository _riskCategoryRepository,
        IUnitOfWork<QMSDbContext> _uow,
        ILogger<DeleteRiskCategoryCommandHandler> _logger) : IRequestHandler<DeleteRiskCategoryCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteRiskCategoryCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entityExist = await _riskCategoryRepository.All.FirstOrDefaultAsync(c => c.Id == request.Id);
                if (entityExist == null)
                {
                    return ServiceResponse<bool>.Return404("risk category not found");
                }
                _riskCategoryRepository.Remove(entityExist);
                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<bool>.Return500();
                }
                return ServiceResponse<bool>.ReturnResultWith200(true);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while deleting RiskCategory");
                return ServiceResponse<bool>.Return500("Error while deleting RiskCategory");
            }
        }
    }
}
