﻿using MediatR;
using QualityManagement.Data.Dto.RiskManagement;
using QualityManagement.Data.Entities;
using QualityManagement.Data.Entities.RiskManagment;
using QualityManagement.Helper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.MediatR.RiskManagement
{
    public class UpdateRiskControlCommand: IRequest<ServiceResponse<RiskControlDto>>
    {
        public Guid Id {  get; set; }
        public string Title { get; set; }
        public string Description { get; set; }
        public Guid RiskId { get; set; }
        public ControlTypeEnum ControlType { get; set; }
        public DateTime ImplementationDate { get; set; }
        public DateTime? ReviewDate { get; set; }
        public RiskStatusEnum Status { get; set; }
        public Guid ResponsibleId { get; set; }
        public EffectivenessEnum Effectiveness { get; set; }
    }
}
