﻿using MediatR;
using QualityManagement.Repository.RiskManagment;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR.RiskManagement
{
    public class GetRiskLogListCommandHandler (
        IRiskLogRepository _riskLogRepository): IRequestHandler<GetRiskLogListCommand, RiskLogList>
    {
        public async Task<RiskLogList> Handle(GetRiskLogListCommand request, CancellationToken cancellationToken)
        {
            return await _riskLogRepository.GetRiskLog(request.RiskLogResource);
        }
    }
}
