﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetRoleQueryHandler(
        IRoleRepository _roleRepository,
         IMapper _mapper,
         ILogger<GetRoleQueryHandler> _logger) : IRequestHandler<GetRoleQuery, RoleDto>
    {
        public async Task<RoleDto> Handle(GetRoleQuery request, CancellationToken cancellationToken)
        {
            var entity = await _roleRepository.AllIncluding(c => c.UserRoles, cs => cs.RoleClaims)
                .Where(c => c.Id == request.Id)
                .FirstOrDefaultAsync();
            if (entity != null)
                return _mapper.Map<RoleDto>(entity);
            else
            {
                var entityDto = new RoleDto
                {
                    StatusCode = 404,
                    Messages = new List<string> { "Not Found Role" }
                };
                _logger.LogWarning($"Not Found Role {entityDto.Name}", entityDto);
                return entityDto;
            }
        }
    }
}
