﻿using MediatR;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetRoleUsersHandler(
        IUserRoleRepository _userRoleRepository) : IRequestHandler<GetRoleUsersQuery, List<UserRoleDto>>
    {
        public Task<List<UserRoleDto>> Handle(GetRoleUsersQuery request, CancellationToken cancellationToken)
        {
            var userRoles = _userRoleRepository
                .AllIncluding(c => c.User)
                .Where(c => c.RoleId == request.RoleId)
                .Select(cs => new UserRoleDto
                {
                    UserId = cs.UserId,
                    RoleId = cs.RoleId,
                    UserName = cs.User.UserName,
                    FirstName = cs.User.FirstName,
                    LastName = cs.User.LastName
                }).ToList();

            return Task.FromResult(userRoles);

        }
    }
}
