﻿using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Dto.Document;
using Microsoft.AspNetCore.Http;
using System;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public interface IStorageService
    {
        Task<UploadFileResponse> UploadBytesAsync(byte[] file, StorageSetting storageSetting, string fileName);
        Task<UploadFileResponse> UploadFileAsync(IFormFile file, StorageSetting storageSetting, string extension);
        Task<DownloadFileResponse> DownloadFileAsync(string fileName, string storageSetting, byte[] key, byte[] iv);
        Task DeleteFileAsync(string fileName, string storageSetting);
        Task<UploadFileResponse> TestUploadFileAsync(IFormFile file, StorageSetting storageSetting, string extension);

        Task<UploadFileResponse> UploadFileChunkAsync(IFormFile file, StorageSetting storageSetting, string extension, byte[] key, byte[] iv);
    }
}
