﻿using System.Threading;
using System.Threading.Tasks;
using MediatR;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetAllSupplierCommandHandler
    (ISupplierRepository supplierRepository) : IRequestHandler<GetAllSupplierCommand, SupplierList>
{
    public async Task<SupplierList> Handle(GetAllSupplierCommand request, CancellationToken cancellationToken)
    {
        return await supplierRepository.GetSuppliers(request.SupplierResource);
    }
}
