﻿using System;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetNewSupplierCodeCommandHandler(ISupplierRepository supplierRepository) : IRequestHandler<GetNewSupplierCodeCommand, string>
{
    public async Task<string> Handle(GetNewSupplierCodeCommand request, CancellationToken cancellationToken)
    {
        var lastSupplierCode = await supplierRepository
                   .All
                   .OrderByDescending(c => c.CreatedDate)
                   .FirstOrDefaultAsync();

        string prefix = "SC";
        int year = DateTime.UtcNow.Year;
        int nextNumber = 1;

        if (lastSupplierCode?.SupplierCode is string lastCode)
        {
            var parts = lastCode.Split('-');
            if (parts.Length == 3 && int.TryParse(parts[2], out int lastNum))
            {
                nextNumber = lastNum + 1;
            }
        }
        return $"{prefix}-{year}-{nextNumber:D5}";
    }
}
