﻿using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetSupplierCommandHandler(
    ISupplierRepository supplierRepository,
    IMapper mapper) : IRequestHandler<GetSupplierCommand, ServiceResponse<SupplierDto>>
{
    public async Task<ServiceResponse<SupplierDto>> Handle(GetSupplierCommand request, CancellationToken cancellationToken)
    {
        var supplier = await supplierRepository.FindAsync(request.Id);
        if (supplier == null)
        {
            return ServiceResponse<SupplierDto>.Return404();
        }
        return ServiceResponse<SupplierDto>.ReturnResultWith200(mapper.Map<SupplierDto>(supplier));
    }
}
