﻿using System;
using MediatR;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Helper;

namespace QualityManagement.MediatR;
public class AddSupplierAuditCommand : IRequest<ServiceResponse<SupplierAuditDto>>
{
    public Guid SupplierId { get; set; }
    public DateTime AuditDate { get; set; }
    public Guid AuditorId { get; set; }
    public SupplierAuditTypeEnum AuditType { get; set; }
    public string Findings { get; set; }
    public int Score { get; set; }
    public string Result { get; set; }
}
