﻿using FluentValidation;

namespace QualityManagement.MediatR;
public class AddSupplierAuditCommandValidator : AbstractValidator<AddSupplierAuditCommand>
{
    public AddSupplierAuditCommandValidator()
    {
        RuleFor(c => c.SupplierId).NotEmpty().WithMessage("SupplierId is required and cannot be empty.");
        RuleFor(c => c.AuditDate).NotEmpty().WithMessage("AuditDate is required.");
        RuleFor(c => c.AuditorId).NotEmpty().WithMessage("AuditorId is required.");
        RuleFor(c => c.AuditType).IsInEnum().WithMessage("AuditType must be a valid enum value.");
        RuleFor(c => c.Findings).NotEmpty().WithMessage("Findings are required.");
        RuleFor(c => c.Score).InclusiveBetween(0, 100).WithMessage("Score must be between 0 and 100.");
        RuleFor(c => c.Result).NotEmpty().WithMessage("Result is required.");
    }
}
