﻿using FluentValidation;

namespace QualityManagement.MediatR;
public class AddSupplierCertificationCommandValidator : AbstractValidator<AddSupplierCertificationCommand>
{
    public AddSupplierCertificationCommandValidator()
    {
        RuleFor(x => x.SupplierId)
            .NotEmpty().WithMessage("SupplierId is required.");

        RuleFor(x => x.CertificationName)
            .NotEmpty().WithMessage("CertificationName is required.");

        RuleFor(x => x.IssuedBy)
            .NotEmpty().WithMessage("IssuedBy is required.");

        RuleFor(x => x.IssuedDate)
            .NotEmpty().WithMessage("IssuedDate is required.");

        RuleFor(x => x.CertificationNumber)
            .NotEmpty().WithMessage("CertificationNumber is required.");

        RuleFor(x => x.Status)
            .NotEmpty().WithMessage("Status is required.");
    }
}
